<?php

namespace App\Listeners;

use Illuminate\Events\Dispatcher;
use Ptb\Synapse\Events\SynapseOrderCreated;
use Ptb\Synapse\Events\SynapseOrderCreating;

class SynapseOrderSubscriber
{
    /**
     * Handle order created events
     *
     * @param SynapseOrderCreated $event
     * @return void
     */
    public function created(SynapseOrderCreated $event)
    {
        //
    }

    /**
     * Handle order creating events
     *
     * @param SynapseOrderCreating $event
     * @return void
     */
    public function creating(SynapseOrderCreating $event)
    {
        //
    }

    /**
     * Register listeners for the subscriber
     *
     * @param Dispatcher $events
     * @return void
     */
    public function subscribe(Dispatcher $events): void
    {
        $events->listen(
            events: SynapseOrderCreated::class,
            listener: [SynapseOrderSubscriber::class, 'created']
        );

        $events->listen(
            events: SynapseOrderCreating::class,
            listener: [SynapseOrderSubscriber::class, 'creating']
        );
    }
}