<?php

namespace Ptb\Sso\Saml;

use Illuminate\Support\ServiceProvider;

class SamlServiceProvider extends ServiceProvider
{

    /**
     * Register any application services
     *
     * @return void
     */
    public function register(): void
    {

    }

    /**
     * Bootstrap any application services
     *
     * @return void
     */
    public function boot(): void
    {
        $this->loadRoutesFrom(
            path: __DIR__ . '/../routes/saml.php'
        );

        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/saml.php',
            key: 'saml'
        );

        $this->publishes([
            __DIR__ . '/../config/saml.php' => config_path('saml.php'),
        ]);

        $this->commands([
            Console\InstallCommand::class,
        ]);
    }

    /**
     * Get the services provided by the provider
     *
     * @return string[]
     */
    public function provides(): array
    {
        return [
            Console\InstallCommand::class,
        ];
    }
}
