<?php

namespace Ptb\Sso\Saml\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Ptb\Sso\Saml\Saml;

class SamlLoginEvent
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    protected Saml $saml;

    public function __construct(Saml $saml)
    {
        $this->saml = $saml;
    }

    public function getSaml(): Saml
    {
        return $this->saml;
    }
}