<?php

namespace Ptb\Sso\Saml\Console;

use Illuminate\Console\Command;
use Illuminate\Filesystem\Filesystem;

class InstallCommand extends Command
{
    protected $signature = 'saml2:install';
    protected $description = 'Install the SAML2 package';

    public function handle(): int
    {
        $files = new Filesystem();

        $files->ensureDirectoryExists(app_path('Listeners'));
        $files->copyDirectory(__DIR__ . '/../../stubs/Listeners', app_path('Listeners'));

        $this->info('Copied Event Listeners to App\Listeners');
        $this->alert('You will need to register the listeners for the Saml2LoginEvent and the Saml2LogoutEvent');

        return 1;
    }
}