<?php

use Illuminate\Support\Facades\Route;
use Ptb\Sso\Saml\Http\Controllers\SamlController;

Route::controller(SamlController::class)
    ->prefix('saml2')
    ->as('saml2.')
    ->group(function () {
        Route::middleware(['web', 'guest'])->get('login', 'index')->name('login');
        Route::middleware(['web'])->get('metadata', 'show')->name('metadata');
        Route::middleware(['web'])->post('acs', 'store')->name('acs');
        Route::middleware(['web', 'auth'])->get('logout', 'destroy')->name('logout');
        Route::middleware(['web', 'auth'])->get('sls', 'forceDelete')->name('sls');
    });
