<?php

namespace Ptb\Sso\OAuth\Google\Http\Controllers;

use Laravel\Socialite\Facades\Socialite;
use Ptb\Sso\OAuth\Google\Events\GoogleLoginEvent;
use Throwable;

class CallbackController extends Controller
{
    public function __invoke()
    {
        try {
            $socialiteUser = Socialite::driver('google')->user();
        } catch (Throwable $e) {
            return redirect()
                ->route('login')
                ->with('status', 'There was a problem logging in with your Google account.');
        }

        $event = new GoogleLoginEvent(
            user: $socialiteUser
        );

        event($event);

        return redirect()
            ->route('home')
            ->with('status', 'You have been logged in');
    }
}