<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class Invoice extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'invoice';
    protected static int $apiCacheFilterExpire = 3600;

    public function __construct(
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualShipDate,
        public float|null $commissionAmountAdjustment,
        public float|null $commissionBaseAdjustment,
        public float|null $taxAmountAdjustment,
        public float|null $taxBaseAdjustment,
        public mixed $altCurrency,
        public mixed $altCurrencyRate,
        public string|null $altCurrencyRateSource,
        public string|null $altCurrencyRateSourceNote,
        public float|null $balanceAmount,
        public bool|null $balanced,
        public mixed $billToContact,
        public string|null $businessUnit,
        public bool|null $calculating,
        public string|null $chargeBackAccount,
        public int|null $closeJob,
        public float|null $commissionAmount,
        public float|null $commissionBase,
        public bool|null $commissionBaseAdjustmentForced,
        public int|null $commissionDistributionMethod,
        public int|null $commissionDistributionSource,
        public float|null $commissionRate,
        public mixed $commissionSalesCategory,
        public int|null $consolidationGroup,
        public string|null $contactFirstName,
        public string|null $contactLastName,
        public string|null $customer,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateSetup,
        public mixed $debitCreditReason,
        public float|null $depositAmount,
        public string|null $description,
        public float|null $discountBase,
        public bool|null $discountBaseForced,
        public bool|null $distributeCommission,
        public bool|null $distributeTax,
        public float|null $distributionRemaining,
        public bool|null $dsfShared,
        public mixed $enteredBy,
        public bool|null $excludeFromConsolidation,
        public bool|null $existingMemos,
        public bool|null $exportedTo3rdParty,
        public mixed $externalTaxResponse,
        public string|null $formNumber,
        public bool|null $freightFromCartonContent,
        public bool|null $handlingFromCartonContent,
        public mixed       $id,
        public string|null $ioID,
        public float|null $invoiceAmount,
        public float|null $invoiceAmountAdjustment,
        public mixed $invoiceBatch,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $invoiceDate,
        public bool|null $invoiceJobParts,
        public int|null $invoiceLevelOptions,
        public string|null $invoiceNum,
        public mixed $invoiceType,
        public bool|null $itemized,
        public mixed $job,
        public string|null $jobPart,
        public mixed $JobPartKey,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed $legalEntity,
        public float|null $lineItemTotal,
        public bool|null $lockCommissionAmount,
        public bool|null $lockCommissionBase,
        public bool|null $lockCustomerDiscount,
        public bool|null $localTaxAmount,
        public bool|null $lockTaxBase,
        public mixed $manufacturingLocation,
        public int|null $memoAccountingPeriod,
        public float|null $memoAdjustment,
        public bool|null $memoApproved,
        public bool|null $memoCommitted,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $memoDate,
        public mixed $memoOf,
        public int|null $nextLineNum,
        public string|null $notes,
        public bool|null $partiallyBill,
        public string|null $partsToInvoice,
        public float|null $percentWipToRelieve,
        public string|null $poNumber,
        public bool|null $postCompleted,
        public bool|null $posted,
        public bool|null $posting,
        public mixed $previousAdminStatus,
        public mixed $previousProductionSTatus,
        public bool|null $printStreamShared,
        public string|null $productsToInvoice,
        public int|null $quantityOrdered,
        public int|null $quantityShipped,
        public bool|null $quickInvoice,
        public mixed $receivable,
        public mixed $reversal,
        public bool|null $reversalInProcess,
        public mixed $reversalOf,
        public string|null $reversalReason,
        public bool|null $review,
        public mixed $salesCategory,
        public int|null $salesDistributionMethod,
        public mixed $salesPerson,
        public mixed $salesTax,
        public int|null $salesTaxBasis,
        public bool|null $sendAsPreInvoice,
        public int|null $sequence,
        public mixed $shipToContent,
        public string|null $shipToFormat,
        public mixed $shipVia,
        public bool|null $showQuickInvoiceReport,
        public mixed $sourceOrganizationCompany,
        public mixed $splitFromInvoice,
        public float|null $splitOriginalInvoiceAmount,
        public bool|null $submittedToOnesource,
        public array|null $tags,
        public float|null $targetSell,
        public float|null $taxAmount,
        public float|null $taxBase,
        public bool|null $taxBaseAdjustmentForced,
        public int|null $taxDistributionMethod,
        public int|null $taxDistributionSource,
        public mixed $taxableCode,
        public bool|null $taxingFailed,
        public bool|null $taxingInProgress,
        public bool|null $taxingRequired,
        public int|null $templateLine,
        public mixed $terms,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $timeSetup,
        public float|null $totalCost,
        public float|null $totalExtras,
        public bool|null $useVAT,
        public float|null $valueAdded,
        public float|null $valuedAddedCost,
        public bool|null $valueAddedForced,
    )
    {
    }

    /**
     * @param mixed $invoiceBatch
     * @return DataCollection
     */
    public static function whereInvoiceBatch(mixed $invoiceBatch): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@invoiceBatch', $invoiceBatch);

        return static::filter($builder);
    }

    /**
     * @return DataCollection
     */
    public function invoiceLines(): DataCollection
    {
        return InvoiceLine::whereInvoice($this->id);
    }

    /**
     * @param InvoiceLine $invoiceLine
     * @return mixed|InvoiceLine
     */
    public function addInvoiceLine(InvoiceLine $invoiceLine): mixed
    {
        $invoiceLine->invoice = $this->id;

        return InvoiceLine::create(data: $invoiceLine);
    }
}
