<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class CartonContent extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'cartonContent';

    public function __construct(
        public mixed $billedContent,
        public mixed $carton,
        public string|null $content,
        public string|null $contentDescription,
        public string|null $contentQuantityOrdered,
        public mixed $id,
        public string|null $ioID,
        public mixed $job,
        public mixed $jobComponent,
        public mixed $jobMaterial,
        public string|null $jobPart,
        public mixed $JobPartKey,
        public mixed $jobPartPressForm,
        public mixed $jobProduct,
        public Carbon|null $lastModified,
        public string|null $note,
        public int|null $originalPlannedQuantity,
        public string|null $productID,
        public mixed $proof,
        public int|null $quantity,
        public int|null $quantityInvoiced,
        public int|null $quantityToBeInvoiced,
        public int|null $sequence,
        public mixed $sourceOrganizationCompany,
        public array|null $tags,
        public int|null $templateLine,
        public int|null $totalQuantity,
    )
    {
    }

    public static function whereCarton(mixed $carton): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@carton', $carton);

        return static::filter($builder);
    }
}
