<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class Carton extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'carton';

    public function __construct(
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualTime,
        public bool|null $addDefaultContent,
        public mixed $component,
        public float|null $cost,
        public int|null $count,
        public mixed $id,
        public string|null $ioID,
        public Carbon|null $lastModified,
        public string|null $note,
        public int|null $printStreamDetailID,
        public int|null $printStreamPackageID,
        public int|null $quantity,
        public string|null $receivedBy,
        public mixed $shipment,
        public mixed $skid,
        public int|null $skidCount,
        public mixed $sourceOrganizationCompany,
        public array|null $tags,
        public int|null $templateLine,
        public int|null $totalQuantity,
        public int|null $totalSkidQuantity,
        public string|null $trackingLink,
        public string|null $trackingNumber,
        public mixed $voiceReceipt,
        public float|null $weight,
    )
    {
    }

    public static function whereShipment(mixed $shipment): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@shipment', $shipment);

        return static::filter($builder);
    }
}
