<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class Customer extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'customer';
    protected static int $apiCacheFilterExpire = 86400;

    public function __construct(
        public float|null  $aging1,
        public float|null  $aging2,
        public float|null  $aging3,
        public float|null  $aging4,
        public string|null $accountTitle,
        public string|null $address1,
        public string|null $address2,
        public string|null $address3,
        public float|null  $agingServiceChargeCurrent,
        public float|null  $agingServiceCharge1,
        public float|null  $agingServiceCharge2,
        public float|null  $agingServiceCharge3,
        public float|null  $agingServiceCharge4,
        public float|null  $agingTotal,
        public bool|null   $allowFailedFreightCheckout,
        public float|null  $allowableOvers,
        public string|null $altAddress1,
        public string|null $altAddress2,
        public string|null $altAddress3,
        public string|null $altCity,
        public mixed       $altCountry,
        public string|null $alternatePhoneNumber,
        public string|null $alternatePhoneExtension,
        public mixed       $altSalutation,
        public string|null $altState,
        public mixed       $altStateKey,
        public string|null $altZip,
        public bool|null   $applyDiscountToInvoice,
        public bool|null   $autoAddContact,
        public float|null  $avgPaymentDays,
        public float|null  $accountBalance,
        public string|null $bankAccountID,
        public mixed       $billRate,
        public bool|null   $billToAlt,
        public mixed       $billToContact,
        public string|null $bsbID,
        public string|null $businessIdNumber,
        public bool|null   $calculateFreight,
        public bool|null   $calculateTax,
        public mixed       $certificationAuthority,
        public mixed       $certificationLevel,
        public string|null $city,
        public int|null    $consolidateInvoices,
        public string|null $contactFirstName,
        public string|null $contactLastName,
        public int|null    $contactNum,
        public string|null $contactTitle,
        public mixed       $country,
        public bool|null   $creditCardProcessingEnabled,
        public int|null    $creditCheck,
        public float|null  $creditLimit,
        public string|null $crmId,
        public mixed       $csr,
        public float|null  $agingCurrent,
        public string|null $custName,
        public mixed       $customerGroup,
        public mixed       $id,
        public string|null $customerLegalName,
        public mixed       $customerStatus,
        public mixed       $customerType,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateHighBalance,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateLastInvoice,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateLastPayment,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateSetup,
        public bool|null   $defaultAlt,
        public mixed       $defaultContact,
        public mixed       $networkLocation,
        public mixed       $defaultCurrency,
        public int|null    $defaultDaysUntilJobDue,
        public mixed       $defaultDsfContact,
        public mixed       $defaultEcommerceShipMethod,
        public mixed       $defaultJob,
        public mixed       $defaultPaymentMethod,
        public mixed       $defaultProductGroup,
        public mixed       $defaultQuoteLetterType,
        public string|null $deliveryZone,
        public string|null $description,
        public float|null  $discountPercent,
        public bool|null   $displayPrice,
        public bool|null   $dsfCustomer,
        public bool|null   $dsfShared,
        public string|null $dunningLetterDeliveryMethod,
        public string|null $email,
        public mixed       $employeeCountType,
        public int|null    $enterInvoicePORequired,
        public int|null    $enterJobPORequired,
        public string|null $eCommerceCheckoutNote,
        public string|null $cartMessage,
        public string|null $serviceMessage,
        public string|null $export,
        public string|null $faxExtension,
        public string|null $faxNumber,
        public float|null  $financeCharge,
        public float|null  $highestBalance,
        public string|null $ibanAccountID,
        public bool|null   $includeTaxInDiscount,
        public mixed       $industryType,
        public string|null $ioID,
        public string|null $invoiceDeliveryMethod,
        public string|null $invoiceMessage,
        public int|null    $ioID1,
        public string|null $iwayCustomerID,
        public bool|null   $jeevesAccountingEnabled,
        public mixed       $jobDifficulty,
        public string|null $jobInvoiceLineDescription,
        public string|null $jobMaterialInvoiceLineDescription,
        public string|null $jobNotes,
        public string|null $jobPartInvoiceLineDescription,
        public string|null $jobPartItemInvoiceLineDescription,
        public string|null $jobProductInvoiceLineDescription,
        public mixed       $language,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $legalEntity,
        public mixed       $logo,
        public mixed       $lookAndFeel,
        public mixed       $manufacturingLocation,
        public string|null $mapSiteURL,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $nextServiceChargeDate,
        public float|null  $nonValueAddedMarkup,
        public bool|null   $onCreditHold,
        public bool|null   $orderAlert,
        public float|null  $outsidePurchaseMarkup,
        public float|null  $overallMarkup,
        public float|null  $overallSellMarkup,
        public float|null  $paperMarkup,
        public mixed       $parentCustomer,
        public string|null $password,
        public string|null $paymentMethod,
        public float|null  $customerTypeAgingTotalPercent,
        public float|null  $aging1Percent,
        public float|null  $aging2Percent,
        public float|null  $aging3Percent,
        public float|null  $aging4Percent,
        public string|null $phoneNumber,
        public string|null $phoneExtension,
        public int|null    $plantManagerId,
        public string|null $pointOfTitleTransfer,
        public mixed       $priceList,
        public int|null    $printNumInvoices,
        public bool|null   $printStreamCustomer,
        public bool|null   $printStreamShared,
        public string|null $printableCompanyID,
        public string|null $printableInventoryToken,
        public string|null $printableJobTicketToken,
        public string|null $printableToken,
        public float|null  $profitability,
        public int|null    $processPrintStreamItems,
        public string|null $profileToken,
        public mixed       $proofContact,
        public string|null $emailPunchoutAdmin,
        public string|null $punchoutHubId,
        public string|null $punchoutIdentity,
        public string|null $sharedSecret,
        public float|null  $quota,
        public string|null $registrationNumber,
        public bool|null   $requireBillOfLadingPerJob,
        public mixed       $revenueType,
        public bool|null   $sage200AccountingEnabled,
        public bool|null   $sage50AccountingEnabled,
        public mixed       $salesCategory,
        public float|null  $salesLastYear,
        public mixed       $salesPerson,
        public mixed       $salesPersonAlt,
        public mixed       $salesTax,
        public mixed       $salesTax2,
        public float|null  $salesYTD,
        public mixed       $salutation,
        public bool|null   $shipBillToAlt,
        public mixed       $shipBillToContact,
        public int|null    $shipInNameOf,
        public bool|null   $shipToAlt,
        public mixed       $shipToContact,
        public string|null $shipToFormat,
        public mixed       $shipVia,
        public string|null $shipmentMessage,
        public string|null $shippingAcctNum,
        public float|null  $shippingMarkup,
        public string|null $sicNumber,
        public mixed       $sourceOrganizationCompany,
        public mixed       $sourceType,
        public string|null $state,
        public mixed       $stateKey,
        public int|null    $statementCycle,
        public string|null $statementDeliveryMethod,
        public string|null $pageflexDeployment,
        public string|null $swiftNumber,
        public array|null  $tags,
        public mixed       $taxCategory,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $taxIDexpires,
        public string|null $taxNum,
        public mixed       $taxableCode,
        public int|null    $templateLine,
        public mixed       $terms,
        public float|null  $unpostedPaymentsBalance,
        public bool|null   $useAlternateText,
        public bool|null   $userPriceListPricing,
        public float|null  $valueAddedMarkup,
        public string|null $vATIdNumber,
        public string|null $vendorNumber,
        public string|null $webSite,
        public float|null  $wipBalance,
        public string|null $zip,
    )
    {
    }

    /**
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('customerStatus/@customerActive', true);

        return static::filter($builder);
    }
}
