<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class InvoiceBatch extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'invoiceBatch';
    protected static int $apiCacheFilterExpire = 3600;

    public function __construct(
        public bool|null   $approved,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $date,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateSetup,
        public string|null $description,
        public mixed       $glAccountingPeriod,
        public mixed       $glRegisterNumber,
        public mixed       $id,
        public string|null $ioID,
        public int|null    $invoiceCount,
        public float|null  $invoiceSum,
        public bool|null   $isExportedToThirdParty,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public bool|null   $manual,
        public int|null    $originalBatchId,
        public bool|null   $posted,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $postedDate,
        public mixed       $reversal,
        public mixed       $sourceOrganizationCompany,
        public int|null    $status,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
    }

    /**
     * @return DataCollection
     */
    public function invoices(): DataCollection
    {
        return Invoice::whereInvoiceBatch($this->id);
    }

    /**
     * @param Invoice $invoice
     * @return mixed|Invoice
     */
    public function addInvoice(Invoice $invoice): mixed
    {
        $invoice->invoiceBatch = $this->id;

        return Invoice::create(data: $invoice);
    }
}
