<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pace_tasks', function (Blueprint $table) {
            $table->id();
            $table->string('task_reference');
            $table->string('task_description');
            $table->string('task_status')->default('pending');
            $table->string('task_estimate_number')->nullable();
            $table->string('task_job_number')->nullable();
            $table->integer('task_job_type_id')->nullable();
            $table->integer('task_sub_job_type_id')->nullable();
            $table->integer('task_job_order_type')->default(1);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pace_tasks');
    }
};
