<?php

namespace Ptb\Pace\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Ptb\Pace\Resources\Jobs\JobProductType;

class PaceAutomationMailing extends Model
{
    use SoftDeletes;

    protected $guarded = [];
    protected $casts = [
        'pace_automation_id' => 'integer',
        'address_format' => 'integer',
        'aspect_ratio' => 'boolean',
        'barcode' => 'boolean',
        'cass_list' => 'boolean',
        'clean_list' => 'boolean',
        'co_mingle' => 'integer',
        'duplicate_address' => 'boolean',
        'extra_stock' => 'boolean',
        'de_dupe_type' => 'integer',
        'insert_type' => 'integer',
        'list_source' => 'integer',
        'mailing_class' => 'integer',
        'mailing_prepared_for' => 'integer',
        'mailing_size' => 'integer',
        'mailing_tabs' => 'integer',
        'mailing_type' => 'integer',
        'matched_mailing' => 'boolean',
        'ncoa_list' => 'boolean',
        'permit_billing' => 'integer',
        'permit_print' => 'integer',
        'permit_used' => 'integer',
        'postage_type' => 'integer',
        'print_case' => 'integer',
        'print_type' => 'integer',
        'remove_duplicate_address' => 'boolean',
        'remove_international' => 'boolean',
        'remove_undeliverable' => 'boolean',
        'return_address' => 'string',
        'return_print' => 'integer',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    public function automation(): BelongsTo
    {
        return $this->belongsTo(PaceAutomation::class, 'pace_automation_id');
    }
}
