<?php

namespace Ptb\Pace\Actions\Estimates;

use Ptb\Pace\Data\EstimatePartInfo;
use Ptb\Pace\Models\PaceTaskPart;

final class CreateEstimatePartInfo
{
    public function __construct(
        private readonly CreateEstimatePaperInfo $paperInfo,
        private readonly CreateEstimatePressInfo $pressInfo,
    )
    {
    }

    /**
     * @param PaceTaskPart $part
     * @param array $options
     * @return EstimatePartInfo
     */
    public function handle(
        PaceTaskPart $part,
        array        $options = [],
    ): EstimatePartInfo
    {
        return EstimatePartInfo::from([
            'bleedsAcross' => $part->automation->job_product_type->bleedsAcross,
            'bleedsAlong' => $part->automation->job_product_type->bleedsAlong,
            'coating' => $part->automation->job_product_type->coating,
            'coatingDry' => $part->automation->job_product_type->coatingDry,
            'coatingSides' => $part->automation->job_product_type->coatingSides,
            'colorsSide1' => $part->automation->job_product_type->colorsSide1,
            'colorsSide2' => $part->automation->job_product_type->colorsSide2,
            'difficulty' => $part->automation->job_product_type->difficulty,
            'eachOf' => $part->automation->each_of,
            'estimatePaperInfo' => $this->paperInfo->handle(part: $part),
            'estimatePressInfo' => $this->pressInfo->handle(part: $part),
            'finalSizeH' => $part->automation->job_product_type->finalSizeHeight,
            'finalSizeW' => $part->automation->job_product_type->finalSizeWidth,
            'foldPattern' => $part->automation->job_product_type->foldPatternKey ?? '2:1',
            'gangable' => $part->automation->job_product_type->gangable,
            'grainSpecifications' => $part->automation->job_product_type->grainSpecifications ?? 1,
            'gripperColorBar' => $part->automation->job_product_type->gripperColorBar,
            'includeMailing' => $part->automation->job_product_type->mailing,
            'inkCoverageBack' => $part->automation->ink_coverage_back,
            'inkCoverageFront' => $part->automation->ink_coverage_front,
            'inkDefault' => $part->automation->job_product_type->inkDefault,
            'inkType' => $part->automation->job_product_type->inkType,
            'numPlies' => $part->automation->job_product_type->numPlies,
            'partDescription' => "{$part->pace_task_id}-{$part->id}-{$part->part_description}",
            'prepressWorkflow' => $part->automation->job_product_type->prepressWorkFlow,
            'pressEventWorkflow' => $part->automation->job_product_type->pressEventWorkflow,
            'pressInkType' => $part->automation->job_product_type->pressInkType,
            'product' => $part->automation->job_product_type->id,
            'productType' => $part->automation->job_product_type->itemProductType,
            'productionType' => $part->automation->job_product_type->productionType,
            'quantity1' => $part->part_qty,
            'salesCategory' => $part->automation->job_product_type->salesCategory,
            'shippingWorkflow' => $part->automation->job_product_type->shippingWorkFlow,
            'speedFactor' => $part->automation->job_product_type->speedFactor,
            'totalColors' => $part->automation->job_product_type->colorsTotal,
            'varnish' => $part->automation->job_product_type->varnish,
            'varnishDry' => $part->automation->job_product_type->varnishDry,
            'varnishSides' => $part->automation->job_product_type->varnishSides,
            'virtualPrinter' => $part->automation->virtual_printer_id,
        ]);
    }
}