<?php

namespace Ptb\Pace\Actions\ChangeOrders;

use Ptb\Pace\Data\ChangeOrder;
use Ptb\Pace\Data\ChangeOrderLine;
use Ptb\Pace\Data\ChangeOrderType;
use Ptb\Pace\Data\Department;
use Ptb\Pace\Data\JobPart;

final class AddPostageAdvance
{

    /**
     * Create change order for postage advance on mailing job part
     *
     * @param JobPart $jobPart
     * @param float $postageAmount
     * @return void
     */
    public function handle(JobPart $jobPart, float $postageAmount = 0): void
    {
        $department = Department::filter()
            ->toCollection()
            ->firstWhere('description', 'Lettershop');

        $changeOrderType = ChangeOrderType::filter()
            ->toCollection()
            ->firstWhere('description', 'Postage Advance');

        $changeOrder = ChangeOrder::create(
            data: ChangeOrder::from([
                'department' => $department->id,
                'description' => 'Postage Advance',
                'job' => $jobPart->job,
                'jobPart' => $jobPart->jobPart,
                'type' => $changeOrderType->id,
            ])
        );

        ChangeOrderLine::create(
            data: ChangeOrderLine::from([
                'billAmt' => $postageAmount,
                'changeOrder' => $changeOrder->id,
                'description' => 'Postage Advance',
                'flatPrice' => $postageAmount,
                'qty' => 1,
                'unitCost' => $postageAmount,
                'unitSell' => $postageAmount,
            ])
        );
    }
}