<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class Estimate extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'estimate';

    public function __construct(
        public int|null    $id,
        public string|null $estimateNumber,
        public string|null $priceSummaryLevel,
        public string|null $state,
        public bool|null   $fromCombo,
        public bool|null   $fromJob,
        public mixed       $salesPerson,
        public mixed       $csr,
        public int|null    $estimator,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $entryDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $entryTime,
        public mixed       $enteredBy,
        public mixed       $customer,
        public string|null $customerProspectName,
        public string|null $description,
        public int|null    $status,
        public bool|null   $estimateRequest,
        public bool|null   $shipToContact,
        public bool|null   $manualEstimateItemWorkflow,
        public bool|null   $manualEstimateItemWorkflowWasEnabled,
        public bool|null   $billToContact,
        public bool|null   $addCRMOpportunity,
        public bool|null   $addCRMActivity,
        public bool|null   $debug,
        public string|null $altCurrency,
        public string|null $altCurrencyRate,
        public string|null $altCurrencyRateSource,
        public string|null $altCurrencyRateSourceNote,
        public bool|null   $forceQuotedPriceOnConvert,
        public bool|null   $committedFromMetrix,
        public bool|null   $recreateLayout,
        public bool|null   $allowVAT,
        public bool|null   $repetitiveRuns,
        public int|null    $manufacturingLocation,
        public bool|null   $highestEstimateVersion,
        public bool|null   $autoAddQuoteLetter,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastChangedDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastChangedTime,
        public string|null $lastChangedBy,
        public bool|null   $previouslyCalcedWithDebug,
        public bool|null   $biasGanging,
        public string|null $selectSHipmentPos,
        public int|null    $totalParts,
        public int|null    $totalPages,
        public bool|null   $hasGangedEstimatePartsOnEstimateLayouts,
    )
    {
    }

    /**
     * @param mixed $estimateNumber
     * @return static|null
     */
    public static function filterByNumber(mixed $estimateNumber): static|null
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@estimateNumber', $estimateNumber);

        return static::filter($builder)->first();
    }
}
