<?php

namespace Ptb\Pace\Requests;

use Ptb\Pace\Data\Estimate;
use Ptb\Pace\Data\EstimateConvertToJob;
use Ptb\Pace\PaceConnector;

final class GetEstimateConvertToJobRequest
{
    public function handle(
        Estimate $estimate
    ): EstimateConvertToJob
    {
        $response = app(PaceConnector::class)
            ->service('InvokeAction')
            ->getEstimateConvertToJob(
                estimate: $estimate,
            );

        return EstimateConvertToJob::from($response);
    }
}