<?php

namespace Ptb\Pace\Services;

use Pace\Services\CloneObject as BaseService;

class CloneObject extends BaseService
{
    /**
     * @param $object
     * @param array $attributes
     * @param array $newAttributes
     * @param $newKey
     * @param array|null $newParent
     * @return array
     */
    public function clone($object, array $attributes, array $newAttributes, $newKey = null, array $newParent = null)
    {
        $request = [
            $object => $attributes,
            $object . 'AttributesToOverride' => $newAttributes,
            'newPrimaryKey' => $newKey,
            'newParent' => $newParent,
        ];

        $response = $this->soap->{'clone' . $object}($request);

        return (array)$response->out;
    }

    /**
     * @param array $attributes
     * @param array $newAttributes
     * @param $newKey
     * @param array|null $newParent
     * @return array
     */
    public function cloneJobPartIntoNewJob(array $attributes, array $newAttributes, $newKey = null, array $newParent = null): array
    {
        $request = [
            'JobPart' => $attributes,
            'JobAttributesToOverride' => $newAttributes,
            'newPrimaryKey' => $newKey,
            'newParent' => $newParent,
        ];

        $response = $this->soap->{'cloneJobPartIntoNewJob'}($request);

        return (array)$response->out;
    }
}
