<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class JobShipment extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'jobShipment';

    public function __construct(
        public string|null $accountNumber,
        public mixed       $activityCode,
        public string|null $address1,
        public string|null $address2,
        public string|null $address3,
        public bool|null   $assignable,
        public mixed       $assignedTo,
        public bool|null   $autoCreated,
        public mixed       $billOfLading,
        public bool|null   $billOfLadingAdd,
        public int|null    $carton1Count,
        public string|null $carton1Note,
        public int|null    $carton1Quantity,
        public int|null    $carton1SkidCount,
        public string|null $carton1TrackingNumber,
        public int|null    $carton2Count,
        public string|null $carton2Note,
        public int|null    $carton2Quantity,
        public int|null    $carton2SkidCount,
        public string|null $carton2TrackingNumber,
        public int|null    $carton3Count,
        public string|null $carton3Note,
        public int|null    $carton3Quantity,
        public int|null    $carton3SkidCount,
        public string|null $carton3TrackingNumber,
        public string|null $chargeBackAccount,
        public string|null $charges,
        public int|null    $childPartialShipmentCount,
        public string|null $city,
        public float|null  $codAmount,
        public bool|null   $codCompanyCheckAcceptable,
        public bool|null   $collapsedInUI,
        public string|null $name,
        public mixed       $component,
        public mixed       $contactNumber,
        public string|null $contactFirstName,
        public string|null $contactLastName,
        public float|null  $cost,
        public int|null    $costDistribution,
        public int|null    $count1,
        public int|null    $count2,
        public int|null    $count3,
        public int|null    $count4,
        public int|null    $count5,
        public int|null    $count6,
        public int|null    $count7,
        public int|null    $count8,
        public int|null    $count9,
        public int|null    $count10,
        public mixed       $country,
        public bool|null   $createdFromEstimate,
        public string|null $customer,
        public Carbon|null $date,
        public bool|null   $dateForced,
        public string|null $description,
        public int|null    $dsfProductID,
        public int|null    $dsfShippingDetailID,
        public string|null $email,
        public string|null $FOB,
        public bool|null   $forcedAccountNumber,
        public mixed       $freightClassificationNumber,
        public bool|null   $freightLinkIntegrated,
        public bool|null   $fromEservice,
        public float|null  $handlingCost,
        public mixed       $id,
        public string|null $ioID,
        public string|null $inventoryBinKey,
        public float|null  $inventoryCost,
        public mixed       $inventoryItem,
        public mixed       $inventoryItemType,
        public string|null $inventoryLocation,
        public int|null    $invoice,
        public mixed       $itemTemplate,
        public mixed       $job,
        public mixed       $jobContact,
        public string|null $jobPart,
        public mixed       $JobPartKey,
        public Carbon|null $lastModified,
        public mixed       $lot,
        public Carbon|null $lotExpirationDate,
        public float|null  $lotJobSellPricePer1000,
        public mixed       $manufacturingLocation,
        public string|null $newInventoryItem,
        public bool|null   $newItem,
        public string|null $note1,
        public string|null $note2,
        public string|null $note3,
        public string|null $note4,
        public string|null $note5,
        public string|null $note6,
        public string|null $note7,
        public string|null $note8,
        public string|null $note9,
        public string|null $note10,
        public string|null $notes,
        public bool|null   $onsiteInstallation,
        public bool|null   $packageDrop,
        public string|null $packageDropType,
        public string|null $phone,
        public string|null $extension,
        public bool|null   $planned,
        public float|null  $plannedQuantity,
        public mixed       $poUom,
        public float|null  $pricePerPOUOM,
        public bool|null   $printStreamFinalPartialShipment,
        public bool|null   $printStreamPartialShipment,
        public string|null $printStreamPullTicketID,
        public string|null $processShipperId,
        public bool|null   $processShipperShipment,
        public mixed       $productionShipment,
        public Carbon|null $promiseDate,
        public Carbon|null $promiseTime,
        public bool|null   $proof,
        public mixed       $proofShipment,
        public int|null    $qtyPicked,
        public int|null    $quantity,
        public int|null    $quantityRemaining,
        public int|null    $quantityStillToReceive,
        public int|null    $quantity1,
        public int|null    $quantity2,
        public int|null    $quantity3,
        public int|null    $quantity4,
        public int|null    $quantity5,
        public int|null    $quantity6,
        public int|null    $quantity7,
        public int|null    $quantity8,
        public int|null    $quantity9,
        public int|null    $quantity10,
        public mixed       $quoteShipment,
        public float|null  $quotedPrice,
        public mixed       $revision,
        public mixed       $salutation,
        public bool|null   $saturday,
        public bool|null   $scheduled,
        public mixed       $scheduledFlag,
        public float|null  $sellingPrice,
        public bool|null   $sendToDSF,
        public bool|null   $sentToProcessShipper,
        public mixed       $shipBillToContact,
        public int|null    $shipInNameOf,
        public bool|null   $shipToInventory,
        public int|null    $shipToInventoryQuantityReceived,
        public mixed       $shipVia,
        public string|null $shipViaNote,
        public mixed       $shipmentType,
        public bool|null   $shipped,
        public string|null $shipperName,
        public mixed       $sourceOrganizationCompany,
        public string|null $state,
        public mixed       $stateKey,
        public array|null  $tags,
        public int|null    $templateLine,
        public float|null  $thickness,
        public float|null  $thirdPartyCharges,
        public Carbon|null $time,
        public bool|null   $timeForced,
        public string|null $trackingLink,
        public string|null $trackingNotes,
        public string|null $trackingNumber,
        public mixed       $UOM,
        public bool|null   $useLegacyPrintFlowFormat,
        public string|null $vendorLotNo,
        public float|null  $weight,
        public float|null  $weightOunces,
        public int|null    $xferBatch,
        public string|null $zip,


    )
    {
    }

    /**
     * @param mixed $job
     * @return DataCollection
     */
    public static function whereJob(mixed $job): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@job', $job);

        return static::filter($builder);
    }
}
