<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class EstimateInfo extends Data
{
    public function __construct(
        public string|null           $customer,
        public string|null           $estimateDescription,
        public EstimatePartInfo|null $estimatePartInfo,
        public int|null              $activity,
        public bool|null             $addCRMActivity,
        public bool|null             $addCRMOpportunity,
        public string|null           $altCurrency,
        public string|null           $budgetAmount,
        public int|null              $contact,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null           $deliveryDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null           $dueDate,
        public string|null           $estimateNumber,
        public int|null              $estimator,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null           $followUpDate,
        public string|null           $freightOnBoard,
        public string|null           $fscCertification,
        public string|null           $notes,
        public int|null              $opportunity,
        public string|null           $prospectAddress1,
        public string|null           $prospectAddress2,
        public string|null           $prospectAddress3,
        public string|null           $prospectCity,
        public string|null           $prospectCompany,
        public string|null           $prospectCountry,
        public string|null           $prospectEmail,
        public string|null           $prospectFax,
        public string|null           $prospectFaxExt,
        public string|null           $prospectName,
        public string|null           $prospectPhone,
        public string|null           $prospectPhoneExt,
        public string|null           $propspectState,
        public string|null           $prospectZip,
        public string|null           $reference,
        public int|null              $salesPerson,
        public string|null           $salesTax,
        public string|null           $taxableCode,
    )
    {
    }
}
