<?php

namespace Ptb\Pace;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Support\ServiceProvider;
use Ptb\Pace\Soap\Factory;
use Ptb\Pace\Console\Commands\CacheWarmupCommand;
use Ptb\Pace\Console\Commands\InstallCommand;

class PaceServiceProvider extends ServiceProvider
{

    /**
     * Register any application services
     *
     * @return void
     */
    public function register(): void
    {
        $this->app->singleton(
            abstract: PaceConnector::class,
            concrete: function ($app) {
                $config = $app['config']['pace'];

                $factory = new Factory();
                $factory->setOptions(
                    options: [
                        'stream_context' => stream_context_create([
                            'ssl' => [
                                'verify_peer' => false,
                                'verify_peer_name' => false,
                            ],
                        ]),
                        'trace' => 1,
                    ]
                );

                return new PaceConnector(
                    soapFactory: $factory,
                    host: $config['host'],
                    login: $config['login'],
                    password: $config['password'],
                    scheme: $config['scheme'],
                );
            }
        );
    }

    /**
     * Bootstrap any application services
     *
     * @return void
     */
    public function boot(): void
    {

        $this->mergeConfigFrom(
            path: __DIR__ . '/../config/pace.php',
            key: 'pace'
        );

//        $this->loadMigrationsFrom(
//            paths: __DIR__ . '/../database/migrations'
//        );

        $this->commands(
            commands: [
                InstallCommand::class,
                CacheWarmupCommand::class,
            ]
        );

        $this->app->booted(function () {
            $schedule = $this->app->make(Schedule::class);
            $schedule->command(CacheWarmupCommand::class)->daily();
        });
    }

    /**
     * Get the services provided by the provider
     *
     * @return string[]
     */
    public function provides(): array
    {
        return [

        ];
    }
}
