<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class NonChargeableTime extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'nonChargeableTime';

    public function __construct(
        public mixed       $costCenter,
        public mixed       $employeeTime,
        public Carbon|null $endDate,
        public Carbon|null $endTime,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $nonChargeableType,
        public string|null $note,
        public int|null    $plantManagerId,
        public mixed       $sourceOrganizationCompany,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startTime,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
    }

}
