<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class NonChargeableType extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'nonChargeableType';
    protected static int $apiCacheFilterExpire = 86400;

    public function __construct(
        public bool|null   $active,
        public string|null $askCostCenter,
        public string|null $askNote,
        public mixed       $costCenter,
        public string|null $description,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public bool|null   $paid,
        public int|null    $plantManagerDMICategory,
        public int|null    $plantManagerId,
        public int|null    $plantManagerReportCategory,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function whereActive(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }
}
