<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class VirtualPrinter extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'virtualPrinter';
    protected static int $apiCacheFilterExpire = 86400;

    public function __construct(
        public bool|null   $active,
        public mixed       $id,
        public string|null $ioID,
        public bool|null   $jobPresets,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $name,
        public mixed       $press,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public string|null $value,
    )
    {
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }
}
