<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class CostCenter extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'costCenter';
    protected static int $apiCacheFilterExpire = 86400;

    public function __construct(
        public bool|null   $active,
        public bool|null   $allowAutoCountLogin,
        public float|null  $budgetedAnnualHours,
        public float|null  $budgetedHourlyRate,
        public float|null  $budgetedHours,
        public mixed       $costCenterType,
        public mixed       $department,
        public string|null $description,
        public int|null    $earliestStartTimePushMinutes,
        public bool|null   $enablePlantManager,
        public int|null    $hoursAvailable,
        public mixed       $id,
        public string|null $ioID,
        public string|null $inventoryBin,
        public mixed       $inventoryLocation,
        public string|null $jdfDeviceID,
        public bool|null   $pdfQuantityFromJobPlan,
        public string|null $jdfSubmitMethod,
        public int|null    $odfSubmitTimeBuffer,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $linkedCostCenter,
        public mixed       $locationBinKey,
        public mixed       $manufacturingLocation,
        public mixed       $paceConnect,
        public mixed       $photo,
        public int|null    $plantManagerId,
        public int|null    $printFlowClass,
        public bool|null   $sentToPrintFlow,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public int|null    $totalImpressions,
        public string|null $webCam,
    )
    {
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }

    /**
     * Query for all active costCenters under specific department
     *
     * @param string $department
     * @return DataCollection
     */
    public static function whereDepartment(string $department): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);
        $builder->filter('@department', $department);

        return static::filter($builder);
    }
}
