<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class ChangeOrderLine extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'changeOrderLine';

    public function __construct(
        public float|null  $billAmt,
        public bool|null   $lineBillFlag,
        public mixed       $changeOrder,
        public string|null $description,
        public float|null  $flatPrice,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public int|null    $lineNum,
        public string|null $lineType,
        public bool|null   $lockUnitPrice,
        public float|null  $ncAmt,
        public int|null    $qty,
        public mixed       $quoteItem,
        public mixed       $salesCategory,
        public mixed       $salesTax,
        public float|null  $shippingAmount,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public float|null  $taxAmount,
        public bool|null   $taxAmountForced,
        public float|null  $taxBase,
        public bool|null   $taxBaseForced,
        public mixed       $taxableCode,
        public int|null    $templateLine,
        public float|null  $unitCost,
        public float|null  $unitSell,
        public mixed       $uom,
    )
    {
    }

}
