<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class JobPartMail extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'jobPartMail';

    public function __construct(
        public mixed       $addressFormat,
        public bool|null   $aspectRatio,
        public bool|null   $barcode,
        public bool|null   $cassList,
        public bool|null   $cleanList,
        public string|null $coMingle,
        public mixed       $deDupeType,
        public float|null  $difference,
        public mixed       $distribution,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dropDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dropTime,
        public bool|null   $duplicateAddress,
        public mixed       $extraStock,
        public string|null $fieldForDeDupe,
        public string|null $fieldsIncluded,
        public mixed       $id,
        public string|null $ioID,
        public mixed       $insertType,
        public string|null $instructions,
        public mixed       $job,
        public mixed       $jobPart,
        public mixed       $JobPartKey,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public mixed       $listSource,
        public mixed       $mailingAttachment,
        public mixed       $mailingClass,
        public mixed       $mailingPreparedFor,
        public mixed       $mailingSize,
        public mixed       $mailingTabs,
        public mixed       $mailingType,
        public bool|null   $matchedMailing,
        public bool|null   $ncoaList,
        public mixed       $permitBilling,
        public mixed       $permitPrint,
        public mixed       $permitUsed,
        public mixed       $postageType,
        public mixed       $printCase,
        public mixed       $printType,
        public bool|null   $processed,
        public bool|null   $removeDuplicateAddress,
        public bool|null   $removeInternational,
        public bool|null   $removeUndeliverable,
        public mixed       $returnAddress,
        public mixed       $returnPrint,
        public mixed       $samples,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
        public int|null    $versions,
    )
    {
    }

    /**
     * @param JobPart $jobPart
     * @return static
     */
    public static function forJobPart(JobPart $jobPart): static
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@job', $jobPart->job);
        $builder->filter('@jobPart', $jobPart->jobPart);
        $results = static::filter($builder);

        return $results->first();
    }
}
