<?php

namespace Ptb\Pace\Actions\Estimates;

use Ptb\Pace\Data\EstimatePressInfo;
use Ptb\Pace\Models\PaceTaskPart;

final class CreateEstimatePressInfo
{
    /**
     * @param PaceTaskPart $part
     * @param array $options
     * @return EstimatePressInfo
     */
    public function handle(
        PaceTaskPart $part,
        array        $options = []
    ): EstimatePressInfo
    {
        return EstimatePressInfo::from([
            'primaryPress' => $part->automation->job_product_type->press,
            'runMethod' => $part->automation->job_product_type->runMethod,
            'runSizeGrainDirection' => $part->automation->job_product_type->runSizeGrainDirection,
            'runSizeH' => $part->automation->job_product_type->runSizeHeight,
            'runSizeW' => $part->automation->job_product_type->runSizeWidth,
        ]);
    }
}