<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class SubJobType extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'subJobType';
    protected static int $apiCacheFilterExpire = 86400;

    public function __construct(
        public bool|null   $active,
        public string|null $description,
        public bool|null   $directMailJob,
        public mixed       $id,
        public string|null $ioID,
        public mixed       $jobType,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }

    /**
     * @param mixed $jobTypeId
     * @return DataCollection
     */
    public static function whereJobType(mixed $jobTypeId): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@jobType', $jobTypeId);

        return static::filter($builder);
    }
}
