<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class JobType extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'jobType';

    public function __construct(
        public bool|null   $active,
        public int|null    $archiveDescription,
        public bool|null   $autoAddProduct,
        public bool|null   $autoApplyDeposits,
        public int|null    $autoCloseJobs,
        public bool|null   $autoEnterOverage,
        public bool|null   $autoEnterUnderage,
        public bool|null   $billPartsTogetherAttribute,
        public int|null    $commissionDistributionMethod,
        public int|null    $commissionDistributionSource,
        public bool|null   $commissionVatTaxDistributions,
        public bool|null   $createJobPartFolders,
        public bool|null   $createJobPartWorkFolders,
        public int|null    $invoiceDateMethod,
        public string|null $description,
        public string|null $useInvoiceDescriptionFrom,
        public bool|null   $displayDeposits,
        public bool|null   $displayPartItems,
        public bool|null   $distributeTax,
        public int|null    $finishedGoodInvoiceDescription,
        public int|null    $finishedGoodInvoiceMethod,
        public mixed       $id,
        public string|null $ioID,
        public int|null    $jacketType,
        public int|null    $jobComponentRatioCalculation,
        public string|null $jobInvoiceLineDescription,
        public string|null $jobMaterialInvoiceLineDescription,
        public bool|null   $invoiceNumIsJobNum,
        public int|null    $jobNumberPrefix,
        public int|null    $jobNumberSequence,
        public string|null $jopPartInvoiceLineDescription,
        public int|null    $jobPartItemInvoiceDescription,
        public string|null $jobPartItemInvoiceLineDescription,
        public string|null $jobProductInvoiceLineDescription,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public int|null    $invoiceLevelOptions,
        public int|null    $lineItemPriceOptions,
        public bool|null   $numberInvoiceOnAdd,
        public int|null    $invoiceQuantity,
        public int|null    $quoteItemInvoiceMethod,
        public mixed       $routingTemplate,
        public int|null    $salesDistributionMethod,
        public bool|null   $separateTaxDistributionForRounding,
        public mixed       $sourceOrganizationCompany,
        public array|null  $tags,
        public int|null    $taxDistributionMethod,
        public int|null    $taxDistributionSource,
        public int|null    $salesTaxBasis,
        public int|null    $templateLine,
        public bool|null   $useManufacturingLocationPRefix,
    )
    {
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }
}
