<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class EmployeeTime extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'employeeTime';

    public function __construct(
        public bool|null   $approved,
        public string|null $approvedBy,
        public string|null $department,
        public mixed       $employee,
        public float|null  $hours,
        public mixed       $id,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lunchStart,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lunchStop,
        public mixed       $payrollPayType,
        public bool|null   $pendingSignOut,
        public float|null  $pRHours,
        public mixed       $sourceOrganizationCompany,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $stopDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $stopTime,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
    }

    /**
     * @param string $employee
     * @param Carbon|null $date
     * @return DataCollection
     */
    public static function whereOpenTime(string $employee, ?Carbon $date = null): DataCollection
    {
        if (empty($date)) {
            $date = now();
        }

        $filter = static::getXPathBuilder();
        $filter->filter('@employee', '=', $employee);
        $filter->filter('@startDate', '=', $date);
        $filter->filter('@stopTime', '=', null);

        return static::filter($filter);
    }
}
