<?php

namespace Ptb\Pace\Actions\Estimates;

use Illuminate\Support\Facades\Storage;
use Ptb\Pace\Data\ContentFile;
use Ptb\Pace\Data\EstimatePart;
use Ptb\Pace\Data\EstimatePartContentFile;
use Ptb\Pace\Models\PaceTaskPart;

final class AddContentFile
{

    /**
     * @param PaceTaskPart $taskPart
     * @param EstimatePart $estimatePart
     * @return void
     */
    public function handle(PaceTaskPart $taskPart, EstimatePart $estimatePart): void
    {
        $contentFile = ContentFile::create(
            data: ContentFile::from([
                'customer' => $taskPart->automation->customer,
                'fileName' => basename($taskPart->part_content_file_location),
                'fileSize' => Storage::disk('public')->size($taskPart->part_content_file_location),
                'fileType' => Storage::disk('public')->mimeType($taskPart->part_content_file_location),
                'fileUrl' => Storage::disk('public')->url($taskPart->part_content_file_location),
            ]),
        );

        EstimatePartContentFile::create(
            data: EstimatePartContentFile::from([
                'contentFile' => $contentFile->id,
                'contentFileCategory' => $taskPart->automation->content_file_category,
                'estimatePart' => $estimatePart->id,
            ])
        );
    }
}