<?php

namespace Ptb\Pace\Actions;

use Ptb\Pace\Data\JobType;
use Ptb\Pace\Data\SubJobType;
use Ptb\Pace\Enums\TaskStatus;
use Ptb\Pace\Models\PaceTask;

final class CreateTaskMailing
{
    /**
     * @param mixed $reference
     * @param string $description
     * @param array $options
     * @return PaceTask
     */
    public function handle(
        mixed  $reference,
        string $description,
        array  $options = [],
    ): PaceTask
    {
        $job_type = JobType::active()
            ->toCollection()
            ->firstWhere('description', 'Mailing');

        $sub_type = SubJobType::whereJobType(jobTypeId: $job_type->id)
            ->toCollection()
            ->firstWhere('description', 'Program');

        return PaceTask::create([
            'task_reference' => $reference,
            'task_description' => $description,
            'task_status' => TaskStatus::Pending,
            'task_job_type_id' => $job_type->id,
            'task_sub_job_type_id' => $sub_type->id,
        ]);
    }
}