<?php

namespace Ptb\Pace\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Ptb\Pace\Enums\TaskStatus;

class PaceTaskPart extends Model
{
    use SoftDeletes;

    protected $guarded = [];
    protected $casts = [
        'pace_automation_id' => 'integer',
        'part_description' => 'string',
        'part_qty' => 'integer',
        'part_job_part' => 'string',
        'part_status' => TaskStatus::class,
        'part_content_file_location' => 'string',
        'part_mail_reports_location' => 'string',
        'part_postage_amount' => 'decimal:3',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];
    protected $appends = [
        'lead_time',
    ];

    public function automation(): BelongsTo
    {
        return $this->belongsTo(PaceAutomation::class, 'pace_automation_id', 'id');
    }

    /**
     * @return int
     */
    public function getLeadTimeAttribute(): int
    {
        return $this->automation->job_lead_time;
    }

}
