<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class EstimateConvertToJob extends Data
{
    public function __construct(
        public float|null                     $allowableOvers,
        public string|null                    $chargeBackNumber,
        public mixed                          $contact,
        public mixed                          $convertIntoJob,
        public mixed                          $customer,
        public string|null                    $description,
        public Estimate|null                  $estimate,
        public EstimateConvertToJobParts|null $estimateConvertToJobParts,
        public int|null                       $invoiceLevelOptions,
        public int|null                       $jobOrderType,
        public mixed                          $jobProject,
        public mixed                          $jobStatus,
        public mixed                          $jobType,
        public mixed                          $lastJob,
        public string|null                    $notes,
        public float|null                     $overrideAddlPerM,
        public float|null                     $overridePrice,
        public int|null                       $oversMethod,
        public string|null                    $poNumber,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null                    $promiseDate,
        public string|null                    $quantityOrdered,
        public bool|null                      $removeExtraJobParts,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null                    $scheduledShipDate,
        public bool|null                      $singleProduct,
        public mixed                          $subJobType,
        public bool|null                      $updateJobInfo,
    )
    {
    }

}
