<?php

namespace Ptb\Pace\Requests;

use Ptb\Pace\Data\EstimatePart;
use Ptb\Pace\Data\EstimatePartInfo;
use Ptb\Pace\PaceConnector;

final class AddEstimatePartRequest
{
    /**
     * @param EstimatePartInfo $estimatePartInfo
     * @return EstimatePart
     */
    public function handle(
        EstimatePartInfo $estimatePartInfo
    ): EstimatePart
    {
        $estimatePart = @app(PaceConnector::class)
            ->service('InvokeAction')
            ->addEstimatePart(
                estimatePartInfo: $estimatePartInfo,
            );

        return EstimatePart::from($estimatePart);
    }
}