<?php

namespace Ptb\Pace\Data;

use Ptb\Pace\Concerns\HasApiMethods;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class ContentFileCategory extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'contentFileCategory';

    public function __construct(
        public bool|null   $active,
        public string|null $contentFileCategoryType,
        public string|null $description,
        public mixed       $id,
        public string|null $ioID,
        public string|null $name,
        public int|null    $sourceOrganizationCompany,
        public int|null    $statusType,
        public bool|null   $systemGenerated,
        public array|null  $tags,
        public int|null    $templateLine,
    )
    {
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }
}
