<?php

namespace Ptb\Pace\Actions\Estimates;

use Ptb\Pace\Data\EstimatePaperInfo;
use Ptb\Pace\Models\PaceTaskPart;

final class CreateEstimatePaperInfo
{

    /**
     * @param PaceTaskPart $part
     * @param array $options
     * @return EstimatePaperInfo
     */
    public function handle(
        PaceTaskPart $part,
        array        $options = [],
    ): EstimatePaperInfo
    {
        return EstimatePaperInfo::from([
            'inventoryItem' => $part->automation->job_product_type->inventoryItem,
            'materialType' => 'InventoryItem',
            'weight' => $part->automation->job_product_type->paperWeight,
        ]);
    }
}