<?php

namespace Ptb\Pace\Console\Commands;

use Illuminate\Console\Command;
use function Laravel\Prompts\password;
use function Laravel\Prompts\text;

class InstallCommand extends Command
{
    protected $signature = 'pace:install';
    protected $description = 'Package installer for PACE';

    public function handle()
    {
        if (config('pace.installed')) {
            $this->error(
                string: 'Install process already complete.'
            );

            return 127;
        }

        $host = text(
            label: 'What is the PACE Url?',
            required: true,
        );

        $login = text(
            label: 'What is the API username?',
            required: true,
        );

        $password = password(
            label: 'What is the API password?',
            required: true,
        );

        $env = fopen(base_path('/.env'), 'a');

        fwrite($env, "\nPACE_HOST={$host}\n");
        fwrite($env, "PACE_LOGIN={$login}\n");
        fwrite($env, "PACE_PASSWORD={$password}\n");
        fwrite($env, "PACE_INSTALLED=1\n");

        fclose($env);

        $this->alert(
            string: 'PACE environment configured'
        );

    }
}
