<?php

namespace Ptb\Pace\Actions;

use Ptb\Accuzip\Models\AccuzipQuote;
use Ptb\Pace\Enums\TaskStatus;
use Ptb\Pace\Models\PaceAutomation;
use Ptb\Pace\Models\PaceTask;
use Ptb\Pace\Models\PaceTaskPart;

final class CreateTaskPartMailing
{
    /**
     * @param AccuzipQuote $quote
     * @param PaceTask $task
     * @param PaceAutomation $automation
     * @param int $quantity
     * @param string $contentFilePath
     * @param string|null $altDescription
     * @param array $options
     * @return PaceTaskPart
     */
    public function handle(
        AccuzipQuote   $quote,
        PaceTask       $task,
        PaceAutomation $automation,
        int            $quantity,
        string         $contentFilePath,
        ?string        $altDescription = null,
        array          $options = [],
    ): PaceTaskPart
    {
        return $task->parts()->create([
            'pace_automation_id' => $automation->id,
            'part_description' => $altDescription ?: $automation->job_product_type->description,
            'part_qty' => $quantity,
            'part_status' => TaskStatus::Pending,
            'part_content_file_location' => $contentFilePath,
            'part_mail_reports_location' => $quote->maildat_filepath,
            'part_postage_amount' => $quote->postage,
        ]);
    }
}