<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class JobStatus extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'jobStatus';
    protected static int $apiCacheFilterExpire = 86400;

    public function __construct(
        public bool|null   $active,
        public bool|null   $admin,
        public bool|null   $adminToProduction,
        public string|null $askComments,
        public string|null $askReason,
        public bool|null   $autoChangable,
        public bool|null   $autoCountOK,
        public bool|null   $billingOK,
        public string|null $description,
        public bool|null   $dsfCancelled,
        public bool|null   $dsfCompleted,
        public mixed       $dsfOrderStatus,
        public bool|null   $editable,
        public string|null $externalStatus,
        public string|null $fieryCentralState,
        public mixed       $id,
        public bool|null   $imposeOK,
        public string|null $inProduction,
        public bool|null   $inTransit,
        public string|null $ioID,
        public bool|null   $jobChargedOK,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public bool|null   $okToFCMakeReadyExport,
        public bool|null   $openJob,
        public bool|null   $pageflexComplete,
        public bool|null   $postActualCostsFromEstimate,
        public bool|null   $printableCancelled,
        public bool|null   $production,
        public bool|null   $readyForDeviceSubmission,
        public bool|null   $schedOK,
        public mixed       $sourceOrganizationCompany,
        public mixed       $statusType,
        public array|null  $tags,
        public int|null    $templateLine,
        public bool|null   $updateJobVersion,
    )
    {
    }

    /**
     * Query only active objects
     *
     * @return DataCollection
     */
    public static function active(): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@active', true);

        return static::filter($builder);
    }
}
