<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\PaceConnector;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;


class JobPart extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'jobPart';
    protected static string $key = '@job:@jobPart';

    public function __construct(
        public string|null $act1Note,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act1Time,
        public string|null $act2Note,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act2Time,
        public string|null $act3Note,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act3Time,
        public string|null $act4Note,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act4Time,
        public string|null $act5Note,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act5Time,
        public string|null $act6Note,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act6Time,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $actualShipDate,
        public string|null $additionalDescription,
        public bool|null   $allowancesChanged,
        public mixed       $billRate,
        public float|null  $billedAmt,
        public float|null  $billedExtrasAmt,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act5Date, // Bindery
        public string|null $binderyWork,
        public string|null $bindingSide,
        public float|null  $bleedSize,
        public mixed       $bleedSizeDisplayUOM,
        public int|null    $bleeds,
        public float|null  $bleedsFace,
        public float|null  $calculatedBleedsFace,
        public mixed       $bleedsFaceDisplayUOM,
        public float|null  $bleedsFoot,
        public float|null  $calculatedBleedsFoot,
        public mixed       $bleedsFootDisplayUOM,
        public float|null  $bleedsHead,
        public float|null  $calculatedBleedsHead,
        public mixed       $bleedsHeadDisplayUOM,
        public float|null  $bleedsSpine,
        public float|null  $calculatedBleedsSpine,
        public mixed       $bleedsSpineDisplayUOM,
        public int|null    $cAutoKey,
        public float|null  $calculatedBackOverfold,
        public float|null  $calculatedFrontOverfold,
        public int|null    $calculatedNumOddPanelsSpine,
        public int|null    $calculatedNumOddPanelsWidth,
        public float|null  $calculatedOddPanelSpineSize,
        public float|null  $calculatedOddPanelWidthSize,
        public bool|null   $calculating,
        public mixed       $certificationAuthority,
        public mixed       $certificationLevel,
        public float|null  $coTotal,
        public int|null    $coCount,
        public string|null $collateOnPrinter,
        public string|null $colors,
        public int|null    $colorsS1,
        public int|null    $colorsS2,
        public int|null    $colorsTotal,
        public mixed       $combinedIntoJob,
        public string|null $componentDescription,
        public int|null    $contactNum,
        public int|null    $contentFile,
        public float|null  $contourPerimeter,
        public mixed       $contourPerimeterUOM,
        public string|null $controlGatesReviewed,
        public mixed       $createdByConnect,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $datePurgeComplete,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dateSetup,
        public bool|null   $defaultPart,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act1Date, // Desktop
        public string|null $description,
        public string|null $desktop,
        public bool|null   $directMailPart,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dueDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $dueTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestStartDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $earliestStartTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $editDate,
        public string|null $estimate,
        public float|null  $estCostPerM,
        public string|null $estimatePart,
        public int|null    $estimateVersion,
        public float|null  $estimatedCost,
        public mixed       $estimator,
        public float|null  $finalSizeH,
        public mixed       $finalSizeHDisplayUOM,
        public float|null  $finalSizeW,
        public mixed       $finalSizeWDisplayUOM,
        public bool|null   $finishedAutoImport,
        public mixed       $binderyMethod,
        public string|null $fiscalWeekSet,
        public string|null $fiscalWeekShip,
        public float|null  $flatSizeH,
        public mixed       $flatSizeHDisplayUOM,
        public float|null  $flatSizeW,
        public mixed       $flatSizeWDisplayUOM,
        public int|null    $foldPattern,
        public mixed       $foldPatternKey,
        public int|null    $folder,
        public int|null    $folderNumUp,
        public string|null $folderNum,
        public float|null  $freightAmt,
        public bool|null   $gangable,
        public mixed       $glLocation,
        public string|null $grain,
        public int|null    $grainSpecifications,
        public int|null    $gripperColorBar,
        public bool|null   $includeMailing,
        public string|null $inkDescS1,
        public string|null $inkDescS2,
        public string|null $ioID,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $invoiceDate,
        public int|null    $invoiceSequence,
        public bool|null   $invoiceW2PHandlingAmount,
        public bool|null   $invoiceW2POrderAmount,
        public bool|null   $invoiceW2PShippingAmount,
        public bool|null   $invoiceW2PTaxAmount,
        public mixed       $itemTemplate,
        public mixed       $itemToReplenish,
        public bool|null   $jdfSubmitted,
        public mixed       $job,
        public mixed       $jobContact,
        public float|null  $jobCost01,
        public float|null  $jobCost02,
        public float|null  $jobCost03,
        public float|null  $jobCost04,
        public float|null  $jobCost05,
        public float|null  $jobCost06,
        public float|null  $jobCost07,
        public float|null  $jobCost08,
        public float|null  $jobCost09,
        public float|null  $jobCost10,
        public string|null $jobPart,
        public string|null $jobPartImportID,
        public int|null    $jobPartVersion,
        public mixed       $jobProduct,
        public mixed       $jobProductType,
        public mixed       $jobType,
        public string|null $jogSide,
        public float|null  $jogTrim,
        public mixed       $jogTrimDisplayUOM,
        public mixed       $lastActCode,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastActDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastActTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastCODate,
        public int|null    $lastCODept,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastCOTime,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastStatusChangedDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastStatusChangedTime,
        public bool|null   $loadBalanced,
        public bool|null   $lockSalesDists,
        public mixed       $manufacturingLocation,
        public float|null  $marginBottom,
        public mixed       $marginBottomDisplayUOM,
        public float|null  $marginRight,
        public mixed       $marginRightDisplayUOM,
        public string|null $materialProvided,
        public string|null $mfgGroup,
        public bool|null   $networkFoldersCreated,
        public string|null $networkFoldersCreationMessage,
        public int|null    $nextSequence,
        public string|null $noScheduleAfterAct,
        public string|null $noScheduleBeforeAc,
        public float|null  $nonImageFace,
        public float|null  $nonImageFoot,
        public float|null  $nonImageHead,
        public float|null  $nonImageSpine,
        public int|null    $numHT,
        public int|null    $numOddPanelsSpine,
        public int|null    $numOddPanelsWidth,
        public int|null    $numPlies,
        public int|null    $numPressForms,
        public int|null    $numPrsShtsOut,
        public int|null    $numSep,
        public int|null    $numSigs,
        public int|null    $numSigsOddPressForm,
        public float|null  $oddPanelSpineSize,
        public float|null  $oddPanelWidthSize,
        public mixed       $originalManufacturingLocation,
        public float|null  $originalQuotedPrice,
        public float|null  $originalQuotedPricePerM,
        public string|null $otherPressWork,
        public string|null $outputResourceID,
        public mixed       $outsidePurchaseWorkflow,
        public string|null $paceConnectFileName,
        public string|null $paceConnectFileSize,
        public string|null $paceConnectFileType,
        public string|null $paceConnectURL,
        public string|null $pageflexDocumentID,
        public int|null    $pages,
        public mixed       $primaryKey,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act6Date, // Paper Due
        public int|null    $parallelFolds,
        public float|null  $value,
        public mixed       $patternCategory,
        public float|null  $pendingBilledAmt,
        public string|null $photos,
        public int|null    $plantManagerId,
        public string|null $plates,
        public string|null $prep,
        public string|null $prepQuoteNum,
        public mixed       $prepressWorkflow,
        public string|null $presentationDirection,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act4Date, // Press
        public int|null    $pressSheetNumOut,
        public mixed       $press1,
        public mixed       $press2,
        public mixed       $previousCreatedByConnect,
        public string|null $previousJobNum,
        public string|null $previousJobRef,
        public mixed       $printRunMethod,
        public int|null    $printStreamItemID,
        public string|null $printStreamProductDescription,
        public string|null $printStreamTicketString,
        public string|null $printableJobTicket,
        public int|null    $printableJobTicketId,
        public string|null $printableOrderDetailID,
        public int|null    $printStreamProductID,
        public mixed       $priority,
        public string|null $processStatus,
        public mixed       $product,
        public mixed       $certificationProductClassification,
        public string|null $productionJob,
        public string|null $productionJobPart,
        public mixed       $productionJobPartKey,
        public mixed       $productionStatus,
        public mixed       $productionType,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act3Date, //Proof Back
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $act2Date, //Proof Out
        public bool|null   $proofPart,
        public string|null $proofs,
        public int|null    $qtyBilled,
        public int|null    $qtyOrdered,
        public int|null    $qtyRemaining,
        public int|null    $qtyShipped,
        public int|null    $qtyToMfg,
        public string|null $queueDestination,
        public string|null $queueEntryID,
        public float|null  $quotePerM,
        public mixed       $quoteProduct,
        public float|null  $quotedPrice,
        public string|null $readingDirection,
        public string|null $statusReasonComment,
        public bool|null   $requiresImposition,
        public int|null    $resolution,
        public int|null    $rightFolds,
        public mixed       $routingTemplate,
        public int|null    $run,
        public int|null    $runMethod,
        public mixed       $salesCategory,
        public bool|null   $scheduled,
        public mixed       $scheduledFlag,
        public string|null $seamDirection,
        public bool|null   $separateLayout,
        public int|null    $sheetsNetRequired,
        public int|null    $sheetsToBindery,
        public mixed       $shipToContact,
        public mixed       $shipToJobContact,
        public mixed       $shippingWorkflow,
        public int|null    $sheetsToPress,
        public int|null    $sides,
        public mixed       $sourceOrganizationCompany,
        public mixed       $speedFactor,
        public int|null    $bleedsAlong,
        public float|null  $calculatedSpineSize,
        public float|null  $spineSize,
        public string|null $statusComments,
        public mixed       $statusReason,
        public int|null    $stitcher,
        public int|null    $stitcherNumUp,
        public mixed       $subJobType,
        public float|null  $calculatedTabFace,
        public float|null  $tabFace,
        public float|null  $calculatedTabFoot,
        public float|null  $tabFoot,
        public float|null  $calculatedTabHead,
        public float|null  $tabHead,
        public float|null  $calculatedTabSpine,
        public float|null  $tabSpine,
        public array|null  $tags,
        public float|null  $targetSellPrice,
        public mixed       $taxCategory,
        public int|null    $templateLine,
        public bool|null   $tileProduct,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $timeSetup,
        public float|null  $totalCost,
        public int|null    $totalDigitalBlackAndWhitePages,
        public int|null    $totalDigitalColorPages,
        public int|null    $totalDigitalPages,
        public float|null  $totalHours,
        public float|null  $transactionCosts,
        public float|null  $transactionHours,
        public float|null  $calculatedTrimFace,
        public float|null  $trimFace,
        public float|null  $calculatedTrimFoot,
        public float|null  $trimFoot,
        public float|null  $calculatedTrimHead,
        public float|null  $trimHead,
        public float|null  $trimSizeHeight,
        public float|null  $trimSizeWidth,
        public float|null  $calculatedTrimSpine,
        public float|null  $trimSpine,
        public mixed       $billUOM,
        public bool|null   $useBasicJacket,
        public bool|null   $useLegacyPrintFlowFormat,
        public bool|null   $usePressForms,
        public string|null $userDefined1,
        public mixed       $userInterfaceSet,
        public mixed       $virtualPrinter,
        public float|null  $visualOpeningFace,
        public float|null  $visualOpeningFoot,
        public float|null  $visualOpeningHead,
        public float|null  $visualOpeningSizeHeight,
        public float|null  $visualOpeningSizeWidth,
        public float|null  $visualOpeningSpine,
        public float|null  $w2pHandlingAmount,
        public float|null  $w2pShippingAmount,
        public float|null  $w2pTaxAmount,
        public int|null    $webOrderLine,
        public int|null    $bleedsAcross,
    )
    {
    }

    /**
     * Filter by job number
     *
     * @param mixed $job
     * @return DataCollection
     */
    public static function whereJob(mixed $job): DataCollection
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@job', $job);

        return static::filter($builder);
    }

    /**
     * @param array $jobAttributes
     * @return $this
     */
    public function cloneIntoNewJob(array $jobAttributes = []): static
    {
        $result = null;
        $pace = @app(PaceConnector::class);
        $pace->transaction(function () use ($pace, $jobAttributes, &$result) {
            $result = $pace->cloneObject(
                object: 'cloneJobPartIntoNewJob',
                attributes: $this->toArray(),
                newAttributes: $jobAttributes,
            );
        });

        return static::from($result ?? []);
    }
}
