<?php

namespace Ptb\Pace\Requests;

use Ptb\Pace\Data\EstimateConvertToJob;
use Ptb\Pace\Data\Job;
use Ptb\Pace\PaceConnector;

final class ConvertEstimateToJobRequest
{
    /**
     * @param EstimateConvertToJob $estimateToJob
     * @return Job
     */
    public static function handle(
        EstimateConvertToJob $estimateToJob
    ): Job
    {
        $response = app(PaceConnector::class)
            ->service('InvokeAction')
            ->convertEstimateToJob(
                estimateConvertToJob: $estimateToJob,
            );

        return Job::from($response);
    }
}