<?php

namespace Ptb\Pace\Nova;

use Laravel\Nova\Fields\HasOne;
use Laravel\Nova\Fields\Number;
use Laravel\Nova\Fields\Select;
use Laravel\Nova\Http\Requests\NovaRequest;
use Laravel\Nova\Panel;
use Laravel\Nova\Resource;
use Ptb\Pace\Data\ContentFileCategory;
use Ptb\Pace\Data\Customer;
use Ptb\Pace\Data\JobProductType;
use Ptb\Pace\Data\ShipVia;
use Ptb\Pace\Data\VirtualPrinter;
use Ptb\Pace\Models\PaceAutomation;

class Automation extends Resource
{
    public static $group = 'Integrations';
    public static $model = PaceAutomation::class;
    public static $title = 'job_product_type.description';
    public static $search = [
        'customer', 'job_product_type.description',
    ];

    public function fields(NovaRequest $request)
    {
        return [
            Select::make('Customer', 'customer')
                ->searchable()
                ->options(fn() => Customer::active()->toCollection()->transform(fn (Customer $item) => ['id' => $item->id, 'name' => $item->custName ?? $item->id])->pluck('name', 'id'))
                ->displayUsingLabels()
                ->required(),
            Select::make('Job Product Type', 'product_type_id')
                ->searchable()
                ->options(fn() => JobProductType::active()->toCollection()->pluck('description', 'id'))
                ->displayUsingLabels()
                ->required(),
            Number::make('Lead Time', 'job_lead_time')
                ->default(7)
                ->required()
                ->help('Used to calculate initial job "Promise Date". Value is the number of days from when the order is placed.'),
            Select::make('Content File Category', 'content_file_category')
                ->options(fn() => ContentFileCategory::active()->toCollection()->pluck('description', 'id'))
                ->displayUsingLabels()
                ->required()
                ->hideFromIndex()
                ->help('When attaching a content file (artwork) during job creation, this marks the stage that the file should be in for the shop to know. Default is Production, as any file from CHILI Publish will be print ready.')
                ->default(2),
            Number::make('Each Of (Num Sigs?)', 'each_of')
                ->required()
                ->hideFromIndex()
                ->help('Not exactly sure what this is for but it required and the default is set to 1.')
                ->default(1),
            Select::make('HP Ticket Template', 'virtual_printer_id')
                ->options(fn() => VirtualPrinter::active()->toCollection()->pluck('name', 'id'))
                ->hideFromIndex()
                ->displayUsingLabels()
                ->nullable(),
            Select::make('Ship Via', 'ship_via')
                ->options(fn() => ShipVia::active()->toCollection()->pluck('description', 'id'))
                ->hideFromIndex()
                ->help('The shipping method used for the completed job.')
                ->nullable(),
            HasOne::make('Mailing', 'mailing', AutomationMailing::class)
                ->hideWhenCreating(),

        ];
    }

    public static function label(): string
    {
        return 'Pace Automations';
    }

    public function cards(NovaRequest $request)
    {
        return [];
    }

    public function filters(NovaRequest $request)
    {
        return [];
    }

    public function lenses(NovaRequest $request)
    {
        return [];
    }

    public function actions(NovaRequest $request)
    {
        return [];
    }
}
