<?php

namespace Ptb\Pace\Actions\Jobs;

use Ptb\Pace\Data\Attachment;
use Ptb\Pace\Data\JobPart;
use Ptb\Pace\Data\JobPartMail;

final class AddMailing
{
    /**
     * @param JobPart $part
     * @param JobPartMail $mail
     * @param Attachment $attachment
     * @return void
     */
    public function handle(
        JobPart $part,
        JobPartMail $mail,
        Attachment   $attachment,
    ): void
    {
        $mailAttachment = JobPartMail::attach(
            key: $mail->id, field: 'mailingAttachment', name: $attachment->name, content: $attachment->attachment
        );

        $mail->mailingAttachment = $mailAttachment;
        JobPartMail::update(data: $mail);

    }
}