<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pace_automations', function (Blueprint $table) {
            $table->id();
            $table->string('customer');
            $table->string('product_type_id');
            $table->integer('content_file_category')->default(2);
            $table->integer('each_of')->default(1);
            $table->integer('ink_coverage_front')->nullable();
            $table->integer('ink_coverage_back')->nullable();
            $table->integer('virtual_printer_id')->nullable();
            $table->integer('ship_via')->nullable();
            $table->integer('job_lead_time')->default(7);
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pace_automations');
    }
};
