<?php

namespace Ptb\Pace\Services;

use Pace\Service;
use Ptb\Pace\Data\Employee;
use Ptb\Pace\Data\Estimate;
use Ptb\Pace\Data\EstimateConvertToJob;
use Ptb\Pace\Data\EstimateInfo;
use Ptb\Pace\Data\EstimatePartInfo;
use Ptb\Pace\Data\Job;

class InvokeAction extends Service
{
    /**
     * @param EstimateInfo $estimateInfo
     * @return array
     */
    public function createEstimate(EstimateInfo $estimateInfo): array
    {
        $response = $this->soap->createEstimate([
            'in0' => $estimateInfo->toArray(),
        ]);

        return (array)$response?->out;
    }

    /**
     * @param EstimatePartInfo $estimatePartInfo
     * @return array
     */
    public function addEstimatePart(EstimatePartInfo $estimatePartInfo): array
    {
        $response = $this->soap->addEstimatePart([
            'in0' => $estimatePartInfo->toArray(),
        ]);

        return (array)$response->out;
    }

    /**
     * @param Estimate $estimate
     * @return array
     */
    public function getEstimateConvertToJob(Estimate $estimate): array
    {
        $response = $this->soap->getEstimateConvertToJob([
            'in0' => $estimate->toArray(),
        ]);

        return (array)$response->out;
    }

    /**
     * @param Estimate $estimate
     * @return array
     */
    public function calculateEstimate(Estimate $estimate): array
    {
        $response = $this->soap->calculateEstimate([
            'in0' => $estimate->toArray(),
        ]);

        return (array)$response->out;
    }

    /**
     * @param Job $job
     * @return array
     */
    public function createEstimateAndConvert(Job $job): array
    {
        $response = $this->soap->createEstimateAndConvert([
            'in0' => $job->toArray()
        ]);

        return (array)$response->out;
    }

    /**
     * @param EstimateConvertToJob $estimateConvertToJob
     * @return array
     */
    public function convertEstimateToJob(EstimateConvertToJob $estimateConvertToJob): array
    {
        $response = $this->soap->convertEstimateToJob([
            'in0' => $estimateConvertToJob->toArray(),
        ]);

        return (array)$response->out;
    }

    /**
     * @param mixed $quote
     * @return array
     */
    public function getQuoteConvertToJob(mixed $quote): array
    {
        $response = $this->soap->getQuoteConvertToJob([
            'in0' => $quote,
        ]);

        return (array)$response->out;
    }

    /**
     * @param mixed $quote
     * @return array
     */
    public function calculateQuote(mixed $quote): array
    {
        $response = $this->soap->calculateQuote([
            'in0' => $quote,
        ]);

        return (array)$response->out;
    }

    /**
     * @param mixed $job
     * @return array
     */
    public function convertQuoteToJob(mixed $job): array
    {
        $response = $this->soap->convertQuoteToJob([
            'in0' => $job,
        ]);

        return (array)$response->out;
    }

    public function employeeSignIn(Employee $employee)
    {
        $response = $this->soap->employeeSignIn([
            'in0' => $employee,
        ]);

        return (array)$response->out;
    }

    public function employeeSignOut(Employee $employee)
    {
        $response = $this->soap->employeeSignOut([
            'in0' => $employee,
        ]);

        return (array)$response->out;
    }

    public function startJobTransaction(Employee $employee, mixed $job, mixed $part, mixed $in3 = null, mixed $in4 = null)
    {
        $response = $this->soap->startJobTransaction([
            'in0' => $employee, //Employee
            'in1' => $job, //string -- JobPlan
            'in2' => $part, //string
            'in3' => $in3, //int
            'in4' => $in4, //string -- ActivityCode
        ]);

        dump($response);

        return (array)$response->out;
    }

    public function stopJobTransaction(Employee $employee, mixed $in1 = '')
    {
        $response = $this->soap->stopJobTransaction([
            'in0' => $employee, //Employee
            'in1' => $in1, //string -- JobCost
        ]);

        dump($response);

        return (array)$response->out;
    }
}