<?php

namespace Ptb\Pace\Data;

use Carbon\Carbon;
use Ptb\Pace\Castables\ToCarbon;
use Ptb\Pace\Concerns\HasApiMethods;
use Ptb\Pace\Transformers\AsCarbon;
use Spatie\LaravelData\Attributes\WithCastable;
use Spatie\LaravelData\Attributes\WithTransformer;
use Spatie\LaravelData\Data;


class Employee extends Data
{
    use HasApiMethods;

    protected static string $apiObjectName = 'employee';

    public function __construct(
        public int|null    $accessPreviousShift,
        public string|null $activityStatus,
        public string|null $address1,
        public string|null $address2,
        public string|null $address3,
        public bool|null   $allowConcurrentEntries,
        public bool|null   $allowEntryCloning,
        public bool|null   $allowGanging,
        public bool|null   $allowPausing,
        public bool|null   $allowQueries,
        public bool|null   $allowReports,
        public bool|null   $askJobComponent,
        public bool|null   $askJobMaterialID,
        public bool|null   $askJobPlanID,
        public bool|null   $askNonPlannedReason,
        public bool|null   $askPayRate,
        public bool|null   $askShift,
        public string|null $autoPayPd,
        public mixed       $bankAccount,
        public float|null  $baseHrsPerPd,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $birthDate,
        public string|null $city,
        public bool|null   $completeRunes,
        public mixed       $country,
        public int|null    $currentNonCharge,
        public mixed       $defaultRate,
        public int|null    $defaultShift,
        public mixed       $department,
        public bool|null   $displayClosedJobs,
        public bool|null   $displayEmployeeTime,
        public bool|null   $displayJobPlanning,
        public bool|null   $displayMaterials,
        public bool|null   $displayNonChargeableTime,
        public bool|null   $editOwnEntriesViaKeypad,
        public string|null $email,
        public string|null $emergencyContact,
        public string|null $emergencyPhone,
        public mixed       $id,
        public string|null $externalID,
        public int|null    $federalExempt,
        public string|null $federalTaxTbl,
        public string|null $firstName,
        public mixed       $glOverrideAccountID,
        public string|null $ioID,
        public bool|null   $isSupervisor,
        public int|null    $jobListType,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastIncreaseDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lastModified,
        public string|null $lastName,
        public int|null    $localExempt,
        public string|null $localTaxTbl,
        public mixed       $location,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lunchStart,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $lunchStop,
        public string|null $nationalInsuranceNum,
        public bool|null   $noLogoutEmailSent,
        public float|null  $normalHrsPerDay,
        public string|null $notes,
        public bool|null   $paidLunch,
        public string|null $password,
        public int|null    $payPdsPerYr,
        public float|null  $payRate01,
        public float|null  $payRate02,
        public float|null  $payRate03,
        public float|null  $payRate04,
        public float|null  $payRate05,
        public float|null  $payRate06,
        public float|null  $payRate07,
        public float|null  $payRate08,
        public float|null  $payRate09,
        public string|null $phoneNumber,
        public string|null $phone2,
        public string|null $phone3,
        public mixed       $photograph,
        public int|null    $plantManagerId,
        public mixed       $printer,
        public bool|null   $pullMultipleMaterials,
        public int|null    $quickEntry,
        public bool|null   $requirePasswordForActionScreen,
        public bool|null   $requirePasswordForLogin,
        public bool|null   $requirePasswordForTransactions,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $reviewDate,
        public float|null  $salaryRate,
        public mixed       $salutation,
        public int|null    $secureId,
        public int|null    $shift,
        public float|null  $sickHrsAccrued,
        public bool|null   $signedIn,
        public mixed       $socialSecurityNum,
        public mixed       $sourceOrganizationCompany,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startDate,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $startTime,
        public string|null $state,
        public int|null    $stateExempt,
        public mixed       $stateKey,
        public string|null $stateTaxTbl,
        public mixed       $status,
        public bool|null   $statutoryEmployee,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $stopTime,
        public array|null  $tags,
        public string|null $taskListMetaData,
        public int|null    $templateLine,
        #[WithCastable(ToCarbon::class)]
        #[WithTransformer(AsCarbon::class)]
        public Carbon|null $terminationDate,
        public bool|null   $useMaterials,
        public float|null  $vacHrsAccrued,
        public int|null    $weeksWorkedQTD,
        public string|null $zip,
    )
    {}

    public static function fromEmail(string $email): Employee|null
    {
        $builder = static::getXPathBuilder();
        $builder->filter('@email', $email);
        $employees = static::filter($builder);

        if ($employees->count() > 0) {
            return $employees->first();
        } else {
            return null;
        }
    }

}
