<?php

namespace Ptb\Pace\Actions\Estimates;

use Ptb\Pace\Data\Attachment;
use Ptb\Pace\Data\EstimateMail;
use Ptb\Pace\Data\EstimatePart;

final class AddMailing
{
    /**
     * @param EstimatePart $part
     * @param EstimateMail $mail
     * @param Attachment $attachment
     * @return void
     */
    public function handle(
        EstimatePart $part,
        EstimateMail $mail,
        Attachment   $attachment,
    ): void
    {
        $mail->estimatePart = $part->id;
        $estimateMail = EstimateMail::create(data: $mail);

        $mailAttachment = EstimateMail::attach(
            key: $estimateMail->id, field: 'mailingAttachment', name: $attachment->name, content: $attachment->attachment
        );

        $estimateMail->mailingAttachment = $mailAttachment;
        EstimateMail::update(data: $estimateMail);

    }
}