<?php

namespace Ptb\Pace\Requests;

use Ptb\Pace\Data\Estimate;
use Ptb\Pace\PaceConnector;

final class CalculateEstimateRequest
{
    /**
     * @param Estimate $estimate
     * @return Estimate
     */
    public function handle(
        Estimate $estimate
    ): Estimate
    {
        $response = app(PaceConnector::class)
            ->service('InvokeAction')
            ->calculateEstimate(
                estimate: $estimate
            );

        return Estimate::from($response);
    }
}